<?php
/**
 * Related Products
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product, $woocommerce_loop;

if ( empty( $product ) || ! $product->exists() ) {
	return;
}

$item_style = 'inner';

$pids = Freshen_Woo_Accessories::get_accessories( $product->get_id() );

if ( empty($pids) || sizeof( $pids ) == 0 ) return;

$args = apply_filters( 'woocommerce_accessories_products_args', array(
	'post_type'            => 'product',
	'ignore_sticky_posts'  => 1,
	'no_found_rows'        => 1,
	'posts_per_page'       => -1,
	'orderby' => 'post__in',
	'post__in' => $pids
) );

$products = freshen_get_products(array(
	'post_per_page' => -1,
	'orderby' => 'post__in',
	'includes' => $pids
));

// $products = new WP_Query( $args );
$total_price = 0;
$count = 0;

if ( $products->have_posts() ) : ?>
	
	<div class="accessoriesproducts">
		<div class="freshen-wc-message"></div>
		<div class="accessoriesproducts-wrapper products row flex-lg flex-md">
			<div class="col-xs-12 col-md-9 no-padding">
				<div class="accessories-products-wrapper widget no-margin">
					<h3 class="widget-title"><?php echo esc_html__('FREQUENTLY BOUGHT TOGETHER','freshen'); ?></h3>
					<div class="item-accessories flex flex-wrap">
						<?php while ( $products->have_posts() ) : $products->the_post(); global $product; ?>
							<?php wc_get_template( 'item-product/inner-accessories.php' ); ?>
							<?php if( $count < $products->post_count - 1 ){ ?>
								<div class="space-accessories flex-middle">+</div>	
							<?php } ?>
							<?php
								$count++;
								$total_price += $product->get_price();
							?>
						<?php endwhile; ?>
					</div>

					<div class="list-items-accessories">
						<ul>
							<?php while ( $products->have_posts() ) : $products->the_post(); global $product; ?>
								<li>
									<div class="flex-middle flex-wrap">
										<div class="name-accessories"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
										<?php echo '<div class="price ali-right">' . wc_price( $product->get_price() ) . $product->get_price_suffix() . '</div>'; ?>
									</div>
								</li>
							<?php endwhile; ?>
						</ul>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-3 flex-middle no-padding">
				<div class="check-item text-center">
					<div class="check-all-items-wrapper">
						<input autocomplete="off" type="checkbox" class="check-all-items" id="check-all-items"/><label for="check-all-items"><?php echo esc_html__('Check All Items', 'freshen'); ?></label>
					</div>
					<div class="total-price-wrapper">
						<?php
							$total_products_html = '<span class="product-count">' . $count . '</span>';
							echo sprintf( _n('Price for %s item', 'Price for %s items', $count, 'freshen'), $total_products_html);
							echo '<span class="total-price">' . wc_price( $total_price ) . $product->get_price_suffix() . '</span>';
						?>
					</div>
					<div class="add-all-items-to-cart-wrapper">
						<button type="button" class="button btn btn-theme btn-block add-all-items-to-cart"><i class="flaticon-shopping-cart"></i><?php echo esc_html__( 'ADD ALL TO CART', 'freshen' ); ?></button>
					</div>
				</div>
			</div>

		</div>

	</div>
<?php endif;
wp_reset_postdata();
?>