<?php 
global $product;
$product_id = $product->get_id();
$image_size = isset($image_size) ? $image_size : 'woocommerce_thumbnail';

?>
<div class="product-block list" data-product-id="<?php echo esc_attr($product_id); ?>">
    <div class="list-product-inner flex-sm">

        <div class="image-left flex">
            <div class="block-inner flex-middle justify-content-center">
                <figure class="image">
                    <?php
                        freshen_product_image($image_size);
                        do_action( 'woocommerce_before_shop_loop_item_title' );
                    ?>
                </figure>
            </div>
        </div>
        <div class="info-right flex">
            <div class="metas clearfix">
                
                <?php freshen_woo_display_product_cat($product_id); ?>

                <?php
                    $rating_html = wc_get_rating_html( $product->get_average_rating() );
                    if ( $rating_html ) {
                        ?>
                        <div class="rating clearfix">
                            <?php echo trim( $rating_html ); ?>
                        </div>
                        <?php
                    }
                ?>

                <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <?php
                    /**
                    * woocommerce_after_shop_loop_item_title hook
                    *
                    * @hooked woocommerce_template_loop_rating - 5
                    * @hooked woocommerce_template_loop_price - 10
                    */
                    remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5);
                    do_action( 'woocommerce_after_shop_loop_item_title');
                ?>    
                
            </div>
            <div class="product-excerpt visible-xs">
                <?php echo freshen_substring( get_the_excerpt(), 10, '...' ); ?>
            </div>
            <div class="product-excerpt hidden-xs">
                <?php echo freshen_substring( get_the_excerpt(), 30, '...' ); ?>
            </div>
            <div class="list-product-bottom">
                <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                <div class="buttons">
                    <?php
                        if ( class_exists( 'YITH_WCWL' ) ) {
                            echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
                        } elseif ( freshen_is_woosw_activated() && get_option('woosw_button_position_archive') == "0" ) {
                            echo do_shortcode('[woosw]');
                        }
                    ?>

                    <?php if ( freshen_get_config('show_quickview', false) ) { ?>
                        <div class="view">
                            <a href="javascript:void(0);" class="quickview" data-product_id="<?php echo esc_attr($product_id); ?>">
                                <i class="ti-search"></i>
                            </a>
                        </div>
                    <?php } ?>

                    <?php if( class_exists( 'YITH_Woocompare_Frontend' ) ) { ?>
                        <?php
                            $obj = new YITH_Woocompare_Frontend();
                            $url = $obj->add_product_url($product_id);
                            $compare_class = '';
                            if ( isset($_COOKIE['yith_woocompare_list']) ) {
                                $compare_ids = json_decode( $_COOKIE['yith_woocompare_list'] );
                                if ( in_array($product_id, $compare_ids) ) {
                                    $compare_class = 'added';
                                    $url = $obj->view_table_url($product_id);
                                }
                            }
                        ?>
                        <div class="yith-compare">
                            <a title="<?php esc_attr_e('compare', 'freshen') ?>" href="<?php echo esc_url( $url ); ?>" class="compare <?php echo esc_attr($compare_class); ?>" data-product_id="<?php echo esc_attr($product_id); ?>">
                                <i class="fa fa-random" aria-hidden="true"></i>
                            </a>
                        </div>
                    <?php } elseif( freshen_is_woosc_activated() && get_option('woosc_button_archive') == "0" ) {?>
                        <?php echo do_shortcode('[woosc]'); ?>
                    <?php } ?>

                </div>
            </div>
        </div>
        
    </div>
</div>