<?php
$post_format = get_post_format();
global $post;
$thumb = freshen_post_thumbnail();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('main-detail-post'); ?>>
    <div class="post-layout">
        <?php if($thumb){ ?>
            <div class="entry-thumb-detail top-image">
                <?php
                    echo trim($thumb);
                ?>
                <?php freshen_post_first_categories($post); ?>
                <a href="<?php the_permalink(); ?>" class="date">
                    <span class="moth"><?php the_time( 'M' ); ?></span>
                    <span class="day"><?php the_time( 'd'); ?></span>
                </a>
            </div>
        <?php }else{ ?>
            <div class="space-10">
                <?php freshen_post_first_categories($post); ?>
            </div>
        <?php } ?>
        <div class="post-layout-info">
            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="flaticon-user"></i><?php echo esc_html__('By','freshen') ?> <?php echo get_the_author(); ?></a>
            <?php if(empty($thumb)){ ?>
                <span class="date"><i class="flaticon-wall-clock"></i><?php the_time( get_option('date_format', 'd M, Y') ); ?></span>
            <?php } ?>
            <span class="comments"><i class="flaticon-chat"></i><?php comments_number( esc_html__('0 Comments', 'freshen'), esc_html__('1 Comment', 'freshen'), esc_html__('% Comments', 'freshen') ); ?></span>
        </div>
    </div>
	<div class="entry-content-detail">
        <div class="wrapper-small">
        	<div class="single-info">
                <div class="entry-description clearfix">
                    <?php
                        the_content();
                    ?>
                </div><!-- /entry-content -->
        		<?php
                wp_link_pages( array(
                    'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'freshen' ) . '</span>',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                    'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'freshen' ) . ' </span>%',
                    'separator'   => '',
                ) );
                ?>
                <?php  
                    $posttags = get_the_tags();
                ?>
                <?php if( !empty($posttags) || freshen_get_config('show_blog_social_share', false) ){ ?>
            		<div class="tag-social clearfix flex-middle-md flex-middle-lg">
                        <?php freshen_post_tags(); ?>
                        <div class="ali-right">
                			<?php if( freshen_get_config('show_blog_social_share', false) ) {
                				get_template_part( 'template-parts/sharebox' );
                			} ?>
                        </div>
            		</div>
                <?php } ?>

                <?php 
                //Previous/next post navigation.
                the_post_navigation( array(
                    'next_text' => 
                        '<div class="inner">'.
                        '<div class="navi">'. esc_html__( 'Next Post', 'freshen' ) . '<i class="flaticon-chevron"></i></div>'.
                        '<span class="title-direct">%title</span></div>',
                    'prev_text' => 
                        '<div class="inner">'.
                        '<div class="navi"><i class="flaticon-left-arrow"></i>' . esc_html__( 'Previous Post', 'freshen' ) . '</div>'.
                        '<span class="title-direct">%title</span></div>',
                ) );
                ?>
        	</div>
        </div>
    </div>
</article>