<?php 
    $thumbsize = !isset($thumbsize) ? freshen_get_config( 'blog_item_thumbsize', 'full' ) : $thumbsize;
    $thumb = freshen_display_post_thumb($thumbsize);
?>
<article <?php post_class('post post-layout post-grid'); ?>>
    <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
        <span class="post-sticky"><?php echo esc_html__('Featured','freshen'); ?></span>
    <?php endif; ?>
    <?php if($thumb) {?>
        <div class="top-image">
            <?php
                echo trim($thumb);
            ?>
            <?php freshen_post_first_categories($post); ?>
            <a href="<?php the_permalink(); ?>" class="date">
                <span class="moth"><?php the_time( 'M' ); ?></span>
                <span class="day"><?php the_time( 'd'); ?></span>
            </a>
        </div>
    <?php } ?>
    <?php if (get_the_title()) { ?>
        <h4 class="entry-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h4>
    <?php } ?>
    <div class="post-layout-info">
        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="flaticon-user"></i><?php echo esc_html__('By','freshen') ?> <?php echo get_the_author(); ?></a>
        <span class="comments"><i class="flaticon-chat"></i><?php comments_number( esc_html__('0 Comments', 'freshen'), esc_html__('1 Comment', 'freshen'), esc_html__('% Comments', 'freshen') ); ?></span>
    </div>
    <?php if( !empty( get_the_excerpt() ) ){?>
        <div class="description"><?php echo freshen_substring( get_the_excerpt(), 20, '...' ); ?></div>
    <?php } ?>
    <div class="readmore">
        <a class="btn-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Continue Reading', 'freshen'); ?></a>
    </div>
</article>