<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Freshen
 * @since Freshen 1.0
 */
/*
*Template Name: Page Default
*/

get_header();
$sidebar_configs = freshen_get_page_layout_configs();
( freshen_is_woocommerce_activated() && (is_cart() || is_checkout()) )?'': freshen_render_breadcrumbs();
?>

<?php 
if(freshen_is_woocommerce_activated() && (is_cart() || is_checkout())){ 
	$style_check = '';
	$breadcrumb_check_img = freshen_get_config('woo_breadcrumb_product_check_image');
	if ( !empty($breadcrumb_check_img['id']) ) {
	    $img_check = wp_get_attachment_image_src($breadcrumb_check_img['id'], 'full');
	    if ( !empty($img_check[0]) ) {
	        $style_check = 'style=background-image:url(\''.esc_url($img_check[0]).'\')';
	    }
	}

	?>
	<div class="apus-checkout-header" <?php echo esc_attr($style_check); ?>>
		<div class="container">
			<div class="apus-checkout-step">
				<ul class="clearfix">
					<li <?php echo trim( (is_cart()) ? 'class="active"':'' ); ?>>
						<div class="inner clearfix">
							<div class="inner-right">
								<div class="inner-step-title">
									<?php esc_html_e('Shopping Cart','freshen'); ?>
								</div>
							</div>
						</div>
					</li>
					<li <?php echo trim( (is_checkout() && empty( is_wc_endpoint_url('order-received') ) ) ? 'class="active"':'' ); ?>>
						<div class="inner clearfix">
							<div class="inner-right">
								<div class="inner-step-title">
									<?php esc_html_e('CHECKOUT','freshen'); ?>
								</div>
							</div>
						</div>
					</li>
					<li <?php echo trim( (is_checkout() && !empty( is_wc_endpoint_url('order-received') )) ? 'class="active"':'' ); ?>>
						<div class="inner clearfix">
							<div class="inner-right">
								<div class="inner-step-title">
									<?php esc_html_e('ORDER COMPLETE','freshen'); ?>
								</div>
							</div>
						</div>
					</li>
				</ul>
			</div>
		</div>
	</div>
<?php } ?>

<section id="main-container" class="<?php echo apply_filters('freshen_page_content_class', 'container');?> inner">
	<?php if ( isset($sidebar_configs['left']) || isset($sidebar_configs['right']) ) : ?>
		<a href="javascript:void(0)" class="mobile-sidebar-btn hidden-lg hidden-md"> <i class="fa fa-bars"></i> <?php echo esc_html__('Show Sidebar', 'freshen'); ?></a>
		<div class="mobile-sidebar-panel-overlay"></div>
	<?php endif; ?>
	<div class="row">
		<?php if ( isset($sidebar_configs['left']) ) : ?>
			<div class="<?php echo esc_attr($sidebar_configs['left']['class']) ;?>">
			  	<aside class="sidebar sidebar-left" itemscope="itemscope" itemtype="//schema.org/WPSideBar">
			   		<?php if ( is_active_sidebar( $sidebar_configs['left']['sidebar'] ) ): ?>
			   			<?php dynamic_sidebar( $sidebar_configs['left']['sidebar'] ); ?>
			   		<?php endif; ?>
			  	</aside>
			</div>
		<?php endif; ?>
		<div id="main-content" class="main-page <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
			<div id="main" class="site-main clearfix" role="main">

				<?php
				// Start the loop.
				while ( have_posts() ) : the_post();
					
					// Include the page content template.
					the_content();

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				// End the loop.
				endwhile;
				?>
			</div><!-- .site-main -->
			<?php
    		wp_link_pages( array(
    			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'freshen' ) . '</span>',
    			'after'       => '</div>',
    			'link_before' => '<span>',
    			'link_after'  => '</span>',
    			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'freshen' ) . ' </span>%',
    			'separator'   => '',
    		) );
    		?>
		</div><!-- .content-area -->
		<?php if ( isset($sidebar_configs['right']) ) : ?>
			<div class="<?php echo esc_attr($sidebar_configs['right']['class']) ;?>">
			  	<aside class="sidebar sidebar-right" itemscope="itemscope" itemtype="//schema.org/WPSideBar">
			   		<?php if ( is_active_sidebar( $sidebar_configs['right']['sidebar'] ) ): ?>
				   		<?php dynamic_sidebar( $sidebar_configs['right']['sidebar'] ); ?>
				   	<?php endif; ?>
			  	</aside>
			</div>
		<?php endif; ?>
	</div>
</section>
<?php get_footer(); ?>