<?php

if ( !function_exists('freshen_get_products') ) {
    function freshen_get_products( $args = array() ) {
        global $woocommerce, $wp_query;

        $args = wp_parse_args( $args, array(
            'categories' => array(),
            'product_type' => 'recent_product',
            'paged' => 1,
            'post_per_page' => -1,
            'orderby' => '',
            'order' => '',
            'includes' => array(),
            'excludes' => array(),
            'author' => '',
        ));
        extract($args);
        
        $query_args = array(
            'post_type' => 'product',
            'posts_per_page' => $post_per_page,
            'post_status' => 'publish',
            'paged' => $paged,
            'orderby'   => $orderby,
            'order' => $order
        );

        if ( isset( $query_args['orderby'] ) ) {
            if ( 'price' == $query_args['orderby'] ) {
                $query_args = array_merge( $query_args, array(
                    'meta_key'  => '_price',
                    'orderby'   => 'meta_value_num'
                ) );
            }
            if ( 'featured' == $query_args['orderby'] ) {
                $query_args = array_merge( $query_args, array(
                    'meta_key'  => '_featured',
                    'orderby'   => 'meta_value'
                ) );
            }
            if ( 'sku' == $query_args['orderby'] ) {
                $query_args = array_merge( $query_args, array(
                    'meta_key'  => '_sku',
                    'orderby'   => 'meta_value'
                ) );
            }
        }

        switch ($product_type) {
            case 'best_selling':
                $query_args['meta_key']='total_sales';
                $query_args['orderby']='meta_value_num';
                $query_args['ignore_sticky_posts']   = 1;
                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;
            case 'featured_product':
                $product_visibility_term_ids = wc_get_product_visibility_term_ids();
                $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'term_taxonomy_id',
                    'terms'    => $product_visibility_term_ids['featured'],
                );
                break;
            case 'top_rate':
                //add_filter( 'posts_clauses',  array( $woocommerce->query, 'order_by_rating_post_clauses' ) );
                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;
            case 'recent_product':
                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;
            case 'deals':
                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $query_args['meta_query'][] =  array(
                    array(
                        'key'           => '_sale_price_dates_to',
                        'value'         => time(),
                        'compare'       => '>',
                        'type'          => 'numeric'
                    )
                );
                break;     
            case 'on_sale':
                $product_ids_on_sale    = wc_get_product_ids_on_sale();
                $product_ids_on_sale[]  = 0;
                $query_args['post__in'] = $product_ids_on_sale;
                break;
            case 'recent_review':
                if($post_per_page == -1) $_limit = 4;
                else $_limit = $post_per_page;
                global $wpdb;
                $query = "SELECT c.comment_post_ID FROM {$wpdb->prefix}posts p, {$wpdb->prefix}comments c
                        WHERE p.ID = c.comment_post_ID AND c.comment_approved > 0 AND p.post_type = 'product' AND p.post_status = 'publish' AND p.comment_count > 0
                        ORDER BY c.comment_date ASC";
                $results = $wpdb->get_results($query, OBJECT);
                $_pids = array();
                foreach ($results as $re) {
                    if(!in_array($re->comment_post_ID, $_pids))
                        $_pids[] = $re->comment_post_ID;
                    if(count($_pids) == $_limit)
                        break;
                }

                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $query_args['post__in'] = $_pids;

                break;
            case 'rand':
                $query_args['orderby'] = 'rand';
                break;
            case 'recommended':

                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = array(
                    'key' => '_apus_recommended',
                    'value' => 'yes',
                );
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;
            case 'recently_viewed':
                $viewed_products = ! empty( $_COOKIE['apus_woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['apus_woocommerce_recently_viewed'] ) : array();
                $viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );

                if ( empty( $viewed_products ) ) {
                    return false;
                }
                $query_args['post__in'] = $viewed_products;
                break;
        }

        if ( !empty($categories) && is_array($categories) ) {
            $query_args['tax_query'][] = array(
                'taxonomy'      => 'product_cat',
                'field'         => 'slug',
                'terms'         => $categories,
                'operator'      => 'IN'
            );
        }

        if (!empty($includes) && is_array($includes)) {
            $query_args['post__in'] = $includes;
        }
        
        if ( !empty($excludes) && is_array($excludes) ) {
            $query_args['post__not_in'] = $excludes;
        }

        if ( !empty($author) ) {
            $query_args['author'] = $author;
        }
        if ( $product_type == 'top_rate' && class_exists('WC_Shortcode_Products') ) {
            add_filter( 'posts_clauses', array( 'WC_Shortcode_Products', 'order_by_rating_post_clauses' ) );
            $loop = new WP_Query($query_args);
            call_user_func( implode('_', array('remove', 'filter')), 'posts_clauses', array( 'WC_Shortcode_Products', 'order_by_rating_post_clauses' ) );
        } else {
            $loop = new WP_Query($query_args);
        }
        return $loop;
    }
}

function freshen_woocommerce_enqueue_scripts() {
    wp_enqueue_script( 'selectWoo' );
    wp_enqueue_style( 'select2' );
    
    wp_register_script( 'sticky-kit', get_template_directory_uri() . '/js/sticky-kit.min.js', array( 'jquery' ), '20150330', true );

    wp_enqueue_script( 'freshen-quantity-increment', get_template_directory_uri() . '/js/wc-quantity-increment.js', array( 'jquery' ), '20150330', true );
    wp_register_script( 'freshen-woocommerce', get_template_directory_uri() . '/js/woocommerce.js', array( 'jquery', 'jquery-unveil', 'slick' ), '20150330', true );

    $ajax_url = add_query_arg( 'wc-ajax', '%%endpoint%%', trailingslashit( site_url() ) );

    $options = array(
        'ajaxurl' => $ajax_url,
        'admin_ajaxurl' => admin_url( 'admin-ajax.php' ),
        'enable_search' => (freshen_get_config('enable_autocompleate_search', true) ? '1' : '0'),
        'empty_msg' => apply_filters( 'freshen_autocompleate_search_empty_msg', esc_html__( 'Unable to find any products that match the currenty query', 'freshen' ) ),
        'nonce' => wp_create_nonce( 'ajax-nonce' ),
        '_preset' => freshen_get_demo_preset()
    );
    wp_localize_script( 'freshen-woocommerce', 'freshen_woo_opts', $options );
    wp_enqueue_script( 'freshen-woocommerce' );
    
    if (freshen_get_config('show_quickview', false)) {
        wp_enqueue_script( 'wc-add-to-cart-variation' );
    }
}
add_action( 'wp_enqueue_scripts', 'freshen_woocommerce_enqueue_scripts', 10 );

// cart
if ( !function_exists('freshen_woocommerce_header_add_to_cart_fragment') ) {
    function freshen_woocommerce_header_add_to_cart_fragment( $fragments ){
        global $woocommerce;
        $fragments['.cart .count'] =  ' <span class="count"> '. $woocommerce->cart->cart_contents_count .' </span> ';
        $fragments['.footer-mini-cart .count'] =  ' <span class="count"> '. $woocommerce->cart->cart_contents_count .' </span> ';
        $fragments['.cart .total-minicart'] = '<div class="total-minicart">'. $woocommerce->cart->get_cart_total(). '</div>';
        return $fragments;
    }
}
add_filter('woocommerce_add_to_cart_fragments', 'freshen_woocommerce_header_add_to_cart_fragment' );

// breadcrumb for woocommerce page
if ( !function_exists('freshen_woocommerce_breadcrumb_defaults') ) {
    function freshen_woocommerce_breadcrumb_defaults( $args ) {
        $breadcrumb_img = freshen_get_config('woo_breadcrumb_image');
        $breadcrumb_color = freshen_get_config('woo_breadcrumb_color');
        $style = $classes = array();
        $show_breadcrumbs = freshen_get_config('show_product_breadcrumbs', true);
        if(is_single()){
            $breadcrumb_img = freshen_get_config('woo_breadcrumb_product_single_image');
            $breadcrumb_color = freshen_get_config('woo_breadcrumb_product_single_color');
        }
        if ( !$show_breadcrumbs ) {
            $style[] = 'display:none';
        }
        if( $breadcrumb_color  ){
            $style[] = 'background-color:'.$breadcrumb_color;
        }
        
        if ( !empty($breadcrumb_img['id']) ) {
            $img = wp_get_attachment_image_src($breadcrumb_img['id'], 'full');
            if ( !empty($img[0]) ) {
                $style[] = 'background-image:url(\''.esc_url($img[0]).'\')';
                $classes[] = 'has_bg';
            }
        }

        $estyle = !empty($style) ? ' style="'.implode(";", $style).'"':"";

        $full_width = 'container';

        // check woo
        if( is_product() ) {
            $title = '';
            if ( freshen_get_config('product_single_fullwidth', false) ) {
                $full_width = 'container-fluid';
            }
        } else {
            $title = '<div class="breadscrumb-inner hidden-icon"><h2 class="bread-title">'.esc_html__( 'Shop', 'freshen' ).'</h2></div>';
            if ( freshen_get_config('product_archive_fullwidth', false) ) {
                $full_width = 'container-fluid';
            }
        }

        $args['wrap_before'] = '<section id="apus-breadscrumb" class="apus-breadscrumb woo-breadcrumb '.esc_attr(!empty($classes) ? implode(' ', $classes) : '').'"'.$estyle.'><div class="'.$full_width.'"><div class="wrapper-breads'.( is_single() ? ' single' : '' ).'"><div class="wrapper-breads-inner">'.$title.'
        <ol class="breadcrumb">';
        $args['wrap_after'] = '</ol></div></div></div></section>';

        return $args;
    }
}
add_filter( 'woocommerce_breadcrumb_defaults', 'freshen_woocommerce_breadcrumb_defaults' );
add_action( 'freshen_woo_template_main_before', 'woocommerce_breadcrumb', 30, 0 );


// display woocommerce modes
if ( !function_exists('freshen_woocommerce_display_modes') ) {
    function freshen_woocommerce_display_modes(){
        global $wp;
        $current_url = freshen_shop_page_link(true);

        $url_grid = add_query_arg( 'display_mode', 'grid', remove_query_arg( 'display_mode', $current_url ) );
        $url_list = add_query_arg( 'display_mode', 'list', remove_query_arg( 'display_mode', $current_url ) );

        $woo_mode = freshen_woocommerce_get_display_mode();

        echo '<div class="display-mode pull-right">';
        echo '<a href="'.  $url_grid  .'" class=" change-view '.($woo_mode == 'grid' ? 'active' : '').'"><i class="ti-layout-grid3"></i></a>';
        echo '<a href="'.  $url_list  .'" class=" change-view '.($woo_mode == 'list' ? 'active' : '').'"><i class="ti-view-list-alt"></i></a>';
        echo '</div>'; 
    }
}

if ( !function_exists('freshen_woocommerce_get_display_mode') ) {
    function freshen_woocommerce_get_display_mode() {
        $woo_mode = freshen_get_config('product_display_mode', 'grid');
        $args = array( 'grid', 'list' );
        if ( isset($_COOKIE['freshen_woo_mode']) && in_array($_COOKIE['freshen_woo_mode'], $args) ) {
            $woo_mode = $_COOKIE['freshen_woo_mode'];
        }
        return $woo_mode;
    }
}

function freshen_before_woocommerce_init() {
    // set display mode to cookie
    if( isset($_GET['display_mode']) && ($_GET['display_mode']=='list' || $_GET['display_mode']=='grid') ){  
        setcookie( 'freshen_woo_mode', trim($_GET['display_mode']) , time()+3600*24*100,'/' );
        $_COOKIE['freshen_woo_mode'] = trim($_GET['display_mode']);
    }
}
add_action( 'init', 'freshen_before_woocommerce_init' );

function freshen_shop_page_link($keep_query = false ) {
    if ( defined( 'SHOP_IS_ON_FRONT' ) ) {
        $link = home_url();
    } elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id('shop') ) ) {
        $link = get_post_type_archive_link( 'product' );
    } else {
        $link = get_term_link( get_query_var('term'), get_query_var('taxonomy') );
    }

    if( $keep_query ) {
        // Keep query string vars intact
        foreach ( $_GET as $key => $val ) {
            if ( 'orderby' === $key || 'submit' === $key ) {
                continue;
            }
            $link = add_query_arg( $key, $val, $link );

        }
    }
    return $link;
}



// add filter to top archive
add_action( 'woocommerce_top_pagination', 'woocommerce_pagination', 1 );


add_action( 'wc_ajax_freshen_ajax_get_products', 'freshen_woocommerce_get_ajax_products' );
function freshen_woocommerce_get_ajax_products() {
    $settings = isset($_POST['settings']) ? $_POST['settings'] : '';

    $tab = isset($_POST['tab']) ? $_POST['tab'] : '';
    
    if ( empty($settings) || empty($tab) ) {
        exit();
    }

    $woo_product_tabs_special = !empty($settings['woo_product_tabs_special']) ? true : false;

    $slugs = !empty($tab['slugs']) ? array_map('trim', explode(',', $tab['slugs'])) : array();

    $columns = isset($settings['columns']) ? $settings['columns'] : 4;
    $columns_tablet = isset($settings['columns_tablet']) ? $settings['columns_tablet'] : 4;
    $columns_mobile = isset($settings['columns_mobile']) ? $settings['columns_mobile'] : 4;
    $slides_to_scroll = isset($settings['slides_to_scroll']) ? $settings['slides_to_scroll'] : 4;
    $slides_to_scroll_tablet = isset($settings['slides_to_scroll_tablet']) ? $settings['slides_to_scroll_tablet'] : 4;
    $slides_to_scroll_mobile = isset($settings['slides_to_scroll_mobile']) ? $settings['slides_to_scroll_mobile'] : 4;
    $autoplay = isset($settings['autoplay']) ? $settings['autoplay'] : false;
    $infinite_loop = isset($settings['infinite_loop']) ? $settings['infinite_loop'] : false;
    $product_item = isset($settings['product_item']) ? $settings['product_item'] : false;

    $rows = isset($settings['rows']) ? $settings['rows'] : 1;
    $show_nav = isset($settings['show_nav']) ? $settings['show_nav'] : false;
    $show_pagination = isset($settings['show_pagination']) ? $settings['show_pagination'] : false;
    $limit = isset($settings['limit']) ? $settings['limit'] : 4;
    $product_type = isset($tab['type']) ? $tab['type'] : 'recent_product';

    $layout_type = isset($settings['layout_type']) ? $settings['layout_type'] : 'grid';

    $excludes = array();

    $args = array(
        'categories' => $slugs,
        'product_type' => $product_type,
        'paged' => 1,
        'post_per_page' => $limit,
        'excludes' => $excludes,
    );

    $loop = freshen_get_products( $args );
    if ( $loop->have_posts() ) {
        $max_pages = $loop->max_num_pages;
        wc_get_template( 'layout-products/'.$layout_type.'.php' , array(
            'loop' => $loop,
            'columns' => $columns,
            'columns_tablet' => $columns_tablet,
            'columns_mobile' => $columns_mobile,
            'slides_to_scroll' => $slides_to_scroll,
            'slides_to_scroll_tablet' => $slides_to_scroll_tablet,
            'slides_to_scroll_mobile' => $slides_to_scroll_mobile,
            'show_nav' => $show_nav,
            'show_pagination' => $show_pagination,
            'autoplay' => $autoplay,
            'infinite_loop' => $infinite_loop,
            'rows' => $rows,
            'product_item' => $product_item,
            'slick_top' => 'slick-carousel-top',
        ) );
    }

    exit();
}

// quickview
add_action( 'wc_ajax_freshen_quickview_product', 'freshen_woocommerce_quickview' );
if ( !function_exists('freshen_woocommerce_quickview') ) {
    function freshen_woocommerce_quickview() {
        if ( !empty($_GET['product_id']) ) {
            $post_object = get_post( $_GET['product_id'] );
            if ( $post_object ) {
                setup_postdata( $GLOBALS['post'] =& $post_object );

                wc_get_template_part( 'content', 'product-quickview' );
            }
            wp_reset_postdata();
        }
        die;
    }
}

// Number of products per page
if ( !function_exists('freshen_woocommerce_shop_per_page') ) {
    function freshen_woocommerce_shop_per_page($number) {
        if (!is_admin()) {
            if ( isset( $_REQUEST['wppp_ppp'] ) ) :
                $number = intval( $_REQUEST['wppp_ppp'] );
                WC()->session->set( 'products_per_page', intval( $_REQUEST['wppp_ppp'] ) );
            elseif ( isset( $_REQUEST['ppp'] ) ) :
                $number = intval( $_REQUEST['ppp'] );
                WC()->session->set( 'products_per_page', intval( $_REQUEST['ppp'] ) );
            elseif ( WC()->session->__isset( 'products_per_page' ) ) :
                $number = intval( WC()->session->__get( 'products_per_page' ) );
            else :
                $value = freshen_get_config('number_products_per_page', 12);
                $number = intval( $value );
            endif;
        }
        return $number;

    }
}
add_filter( 'loop_shop_per_page', 'freshen_woocommerce_shop_per_page', 30 );

// Number of products per row
if ( !function_exists('freshen_woocommerce_shop_columns') ) {
    function freshen_woocommerce_shop_columns($number) {
        $value = freshen_get_config('product_columns');
        if ( in_array( $value, array(1, 2, 3, 4, 5, 6, 7, 8) ) ) {
            $number = $value;
        }
        return $number;
    }
}
add_filter( 'loop_shop_columns', 'freshen_woocommerce_shop_columns' );

// share box
if ( !function_exists('freshen_woocommerce_share_box') ) {
    function freshen_woocommerce_share_box() {
        if ( freshen_get_config('show_product_social_share', false) ) {
            get_template_part( 'template-parts/sharebox' );
        }
    }
}


function freshen_product_get_layout_type() {
    global $post;
    $layout = get_post_meta($post->ID, 'apus_product_layout_type', true);
                    
    if ( empty($layout) ) {
        $layout = freshen_get_config('product_single_version', 'v1');
    }
    return $layout;
}


function freshen_woo_display_product_cat($product_id) {
    $terms = get_the_terms( $product_id, 'product_cat' );
    if ( !empty($terms) && !empty($terms[0]) ) { ?>
        <div class="product-cat">
        <?php
            $term = $terms[0];
            echo '<a href="' . get_term_link( $term ) . '">' . $term->name . '</a>';
        ?>
        </div>
    <?php
    }
}


// Wishlist
add_filter( 'yith_wcwl_add_to_wishlist_icon_html', 'freshen_woocomerce_icon_wishlist'  );

function freshen_woocomerce_icon_wishlist( $value='' ){
    return '<span class="heart-icon"><i class="flaticon-heart"></i></span>';
}


function freshen_yith_wcwl_positions($positions) {
    if ( isset($positions['add-to-cart']['hook']) ) {
        $positions['add-to-cart']['hook'] = 'woocommerce_single_product_summary';
        $positions['add-to-cart']['priority'] = 35;
    }
    return $positions;
}
add_filter( 'yith_wcwl_positions', 'freshen_yith_wcwl_positions', 100 );


function freshen_product_breadcrumbs_navigation() {
    ?>
    <div class="breadcrumb-navigation-wrapper">
        <?php freshen_display_in_stock(); ?>
        <div class="product-navs">
            <?php
                the_post_navigation( array(
                    'prev_text' => '<i class="flaticon-left-arrow"></i>'.esc_html__('PREV', 'freshen'),
                    'next_text' => esc_html__('NEXT', 'freshen').'<i class="flaticon-chevron"></i>',
                ) );
            ?>
        </div>
    </div>
    <?php
}

function freshen_product_bought_together() {
    get_template_part( 'woocommerce/single-product/accessories' );
}

// countdown
function freshen_woocommerce_single_countdown() {
    if ( freshen_get_config('show_product_countdown_timer') ) {
        get_template_part( 'woocommerce/single-product/countdown' );
    }
}
add_action('woocommerce_single_product_summary', 'freshen_woocommerce_single_countdown', 21);


// swap effect
if ( !function_exists('freshen_swap_images') ) {
    function freshen_swap_images() {
        $thumb = apply_filters('freshen_swap_images_thumb', 'woocommerce_thumbnail');
        $swap_image = (bool)freshen_get_config('enable_swap_image', true);
        ?>
        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="product-image">
            <?php freshen_product_get_image($thumb, $swap_image); ?>
        </a>
        <?php
    }
}
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);

if ( !function_exists('freshen_product_image') ) {
    function freshen_product_image($thumb = 'woocommerce_thumbnail') {
        $swap_image = (bool)freshen_get_config('enable_swap_image', true);
        ?>
        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="product-image">
            <?php freshen_product_get_image($thumb, $swap_image); ?>
        </a>
        <?php
    }
}
// get image
if ( !function_exists('freshen_product_get_image') ) {
    function freshen_product_get_image($thumb = 'woocommerce_thumbnail', $swap = true) {
        global $post, $product, $woocommerce;
        
        $output = '';
        $class = "attachment-$thumb size-$thumb image-no-effect";
        if (has_post_thumbnail()) {
            if ( $swap ) {
                $attachment_ids = $product->get_gallery_image_ids();
                if ($attachment_ids && isset($attachment_ids[0])) {
                    $class = "attachment-$thumb size-$thumb image-hover";
                    $swap_class = "attachment-$thumb size-$thumb image-effect";
                    $output .= freshen_get_attachment_thumbnail( $attachment_ids[0], $thumb , false, array('class' => $swap_class), false);
                }
            }
            $output .= freshen_get_attachment_thumbnail( get_post_thumbnail_id(), $thumb , false, array('class' => $class), false);
        } else {
            $output .= '<img src="'.wc_placeholder_img_src().'" alt="'.esc_attr__('Placeholder' , 'freshen').'" class="'.$class.'"/>';
        }
        echo trim($output);
    }
}
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );


function freshen_wc_get_gallery_image_html_simple( $attachment_id, $main_image = false ) {
    $flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', get_theme_support( 'wc-product-gallery-slider' ) );
    $gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
    $thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
    $image_size        = apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size );
    $full_size         = apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
    $thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
    $full_src          = wp_get_attachment_image_src( $attachment_id, $full_size );
    
    
    $img = freshen_get_attachment_thumbnail($attachment_id, $image_size);
    return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" class="woocommerce-product-gallery__image"><a href="' . esc_url( $full_src[0] ) . '">' . $img . '</a></div>';
}

// layout class for woo page
if ( !function_exists('freshen_woocommerce_content_class') ) {
    function freshen_woocommerce_content_class( $class ) {
        $page = 'archive';
        if ( is_singular( 'product' ) ) {
            $page = 'single';
        }
        if( freshen_get_config('product_'.$page.'_fullwidth', false) ) {
            return 'container-fluid max-1800';
        }
        return $class;
    }
}
add_filter( 'freshen_woocommerce_content_class', 'freshen_woocommerce_content_class' );

// get layout configs
if ( !function_exists('freshen_get_woocommerce_layout_configs') ) {
    function freshen_get_woocommerce_layout_configs() {
        $page = 'archive';
        if ( is_singular( 'product' ) ) {
            $page = 'single';
        }
        $left = freshen_get_config('product_'.$page.'_left_sidebar');
        $right = freshen_get_config('product_'.$page.'_right_sidebar');
        // check full width
        if( freshen_get_config('product_'.$page.'_fullwidth') ) {
            $sidebar = 'col-lg-2';
            $main_full = 'col-lg-10';
        } else {
            $sidebar = 'col-lg-3';
            $main_full = 'col-lg-9';
        }
        switch ( freshen_get_config('product_'.$page.'_layout', 'main') ) {
            case 'left-main':
                if ( is_active_sidebar( $left ) ) {
                    $configs['left'] = array( 'sidebar' => $left, 'class' => $sidebar.' col-md-3 col-sm-12 col-xs-12 shop-sidebar-left-wrapper'  );
                    $configs['main'] = array( 'class' => $main_full.' col-md-9 col-sm-12 col-xs-12 shop-has-left' );
                }
                break;
            case 'main-right':
                if ( is_active_sidebar( $right ) ) {
                    $configs['right'] = array( 'sidebar' => $right,  'class' => $sidebar.' col-md-3 col-sm-12 col-xs-12 shop-sidebar-right-wrapper' ); 
                    $configs['main'] = array( 'class' => $main_full.' col-md-9 col-sm-12 col-xs-12 shop-has-right' );
                }
                break;
            case 'main':
                $configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
                break;
            default:
                if (is_active_sidebar( 'sidebar-default' ) && !is_shop() && !is_single() ) {
                    $configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-3 col-sm-12 col-xs-12' ); 
                    $configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
                } else {
                    $configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
                }
                break;
        }

        if ( empty($configs) ) {
            if (is_active_sidebar( 'sidebar-default' ) && !is_shop() && !is_single() ) {
                $configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-3 col-sm-12 col-xs-12' ); 
                $configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
            } else {
                $configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
            }
        }

        return $configs; 
    }
}

if ( !function_exists( 'freshen_product_review_tab' ) ) {
    function freshen_product_review_tab($tabs) {
        global $post;
        if ( !freshen_get_config('show_product_review_tab', true) && isset($tabs['reviews']) ) {
            unset( $tabs['reviews'] ); 
        }

        if ( !freshen_get_config('hidden_product_additional_information_tab', false) && isset($tabs['additional_information']) ) {
            unset( $tabs['additional_information'] ); 
        }
        
        return $tabs;
    }
}
add_filter( 'woocommerce_product_tabs', 'freshen_product_review_tab', 90 );


// Loop
/*
 * Start for only Freshen theme
 */
function freshen_is_ajax_request() {
    if ( isset( $_REQUEST['load_type'] ) ) {
        return true;
    }
    return false;
}

function freshen_edit_product_term($term_id, $tt_id, $taxonomy) {
    $term = get_term($term_id,$taxonomy);
    if (!is_wp_error($term) && is_object($term)) {
        $taxonomy = $term->taxonomy;
        if ($taxonomy == "product_cat") {
            freshen_delete_transients_with_prefix( 'freshen-product-categories' );
        }
    }
}
 
function freshen_delete_product_term($term_id, $tt_id, $taxonomy, $deleted_term) {
    if (!is_wp_error($deleted_term) && is_object($deleted_term)) {
        $taxonomy = $deleted_term->taxonomy;
        if ($taxonomy == "product_cat") {
            freshen_delete_transients_with_prefix( 'freshen-product-categories' );
        }
    }
}
add_action( 'create_term', 'freshen_edit_product_term', 99, 3 );
add_action( 'edit_term', 'freshen_edit_product_term', 99, 3 );
add_action( 'delete_term', 'freshen_delete_product_term', 99, 4 );
 
add_action( 'save_post', 'freshen_save_post_action', 99, 3);
function freshen_save_post_action( $post_id ){

    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if (!current_user_can( 'edit_page', $post_id ) ) return;
 
    $post_info = get_post($post_id);
 
    if (!is_wp_error($post_info) && is_object($post_info)) {
        if ($post_info->post_type == "product") {
            freshen_delete_transients_with_prefix( 'freshen-product-categories' );
        }
    }
}

function freshen_delete_transients_with_prefix( $prefix ) {
    foreach ( freshen_get_transient_keys_with_prefix( $prefix ) as $key ) {
        delete_transient( $key );
    }
}

function freshen_get_transient_keys_with_prefix( $prefix ) {
    global $wpdb;

    $prefix = $wpdb->esc_like( '_transient_' . $prefix );
    $sql = "SELECT `option_name` FROM $wpdb->options WHERE `option_name` LIKE '%s'";
    $keys = $wpdb->get_results( $wpdb->prepare( $sql, $prefix . '%' ), ARRAY_A );

    if ( is_wp_error( $keys ) ) {
        return [];
    }
    return array_map( function( $key ) {
        return ltrim( $key['option_name'], '_transient_' );
    }, $keys );
}




if (!function_exists('freshen_filter_before')) {
    function freshen_filter_before() {
        echo '<div class="wrapper-fillter"><div class="apus-filter clearfix">';
    }
}

if (!function_exists('freshen_filter_after')) {
    function freshen_filter_after() {
        echo '</div></div>';
    }
}

function freshen_product_filter_sidebar() {
    $layout = freshen_get_config('product_archive_layout', 'left-main');
    if ( is_active_sidebar( 'shop-filter-sidebar' ) && $layout == 'main' && freshen_get_config('product_archive_show_filter_top', true) ) {
        
        ?>
        <div class="filter-btn-wrapper style1">
            <a href="javascript:void(0);" class="filter-btn"><i class="flaticon-setting-lines"></i><?php esc_html_e('Filter', 'freshen'); ?></a>

            <div class="shop-filter-sidebar-wrapper">
                <div class="shop-filter-sidebar-header">
                    <?php esc_html_e('Filter by', 'freshen'); ?>
                    <a href="javascript:void(0);" class="close-filter"><i class="ti-close"></i></a>
                </div>
                <div class="content-inner sidebar">
                    <?php dynamic_sidebar( 'shop-filter-sidebar' ); ?>
                </div>
            </div>
            <div class="shop-filter-sidebar-overlay"></div>
        </div>
        <?php
    }
}

function freshen_filter_colmun_before() {
    ?>
    <div class="wrapper-right">
        <div class="left-inner clearfix">
    <?php
}
function freshen_filter_colmun_after() {
    ?>
    </div></div>
    <?php
}

function freshen_woocommerce_before_shop_loop_init() {
    add_action( 'woocommerce_before_shop_loop', 'freshen_filter_before' , 11 );
    add_action( 'woocommerce_before_shop_loop', 'freshen_filter_colmun_before', 25 );

    add_action( 'woocommerce_before_shop_loop', 'freshen_product_filter_sidebar' , 26 );

    add_action( 'woocommerce_before_shop_loop', 'freshen_woocommerce_display_modes', 50 );

    add_action( 'woocommerce_before_shop_loop', 'freshen_filter_colmun_after' , 99 );
    add_action( 'woocommerce_before_shop_loop', 'freshen_filter_after' , 100 );
}
add_action( 'init', 'freshen_woocommerce_before_shop_loop_init' );

function freshen_show_sale_percentage_loop() {
    global $product;
     
    if ( $product->is_on_sale() ) {
        if ( ! $product->is_type( 'variable' ) ) {
            $price = $product->get_regular_price();
            $sale = $product->get_sale_price();
            if ( $sale && $price ) {
                $max_percentage = ( ( $price - $sale ) / $price ) * 100;
            }
        } else {
            $max_percentage = 0;
            foreach ( $product->get_children() as $child_id ) {
                $variation = wc_get_product( $child_id );
                $price = $variation->get_regular_price();
                $sale = $variation->get_sale_price();
                $percentage = 0;
                if ( $price != 0 && ! empty( $sale ) ) {
                    $percentage = ( $price - $sale ) / $price * 100;
                }
                if ( $percentage > $max_percentage ) {
                    $max_percentage = $percentage;
                }
            }
        }
        if ( !empty($max_percentage) ) {
            echo "<div class='sale-perc'>-" . round($max_percentage) . " %</div>";
        }
    }
 
}
add_action( 'woocommerce_before_shop_loop_item_title', 'freshen_show_sale_percentage_loop', 25 );
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);

function freshen_display_out_of_stock() {
    global $product;
    if ( ! $product->is_in_stock() ) {
        echo '<p class="stock out-of-stock">'.esc_html__('SOLD OUT', 'freshen').'</p>';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'freshen_display_out_of_stock', 10 );

function freshen_display_in_stock() {
    global $product;
    if ( $product->is_in_stock() ) {
        echo '<div class="stock"><div class="in-stock">'.esc_html__('In Stock', 'freshen').'</div></div>';
    }
}

// catalog mode
add_action( 'wp', 'freshen_catalog_mode_init' );
add_action( 'wp', 'freshen_pages_redirect' );

function freshen_catalog_mode_init() {
    if( ! freshen_get_config( 'enable_shop_catalog' ) ) return false;

    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
}

function freshen_pages_redirect() {
    if( ! freshen_get_config( 'enable_shop_catalog' ) ) return false;

    $cart     = is_page( wc_get_page_id( 'cart' ) );
    $checkout = is_page( wc_get_page_id( 'checkout' ) );

    wp_reset_postdata();

    if ( $cart || $checkout ) {
        wp_redirect( home_url() );
        exit;
    }
}

function freshen_wc_get_gallery_image_html( $attachment_id, $main_image = false ) {
    $flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', get_theme_support( 'wc-product-gallery-slider' ) );
    $gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
    $thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
    $image_size        = apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size );
    $full_size         = apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
    $thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
    $full_src          = wp_get_attachment_image_src( $attachment_id, $full_size );
    $alt_text          = trim( wp_strip_all_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) ) );
    $image             = wp_get_attachment_image(
        $attachment_id,
        $image_size,
        false,
        apply_filters(
            'woocommerce_gallery_image_html_attachment_image_params',
            array(
                'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
                'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
                'data-src'                => esc_url( $full_src[0] ),
                'data-large_image'        => esc_url( $full_src[0] ),
                'data-large_image_width'  => esc_attr( $full_src[1] ),
                'data-large_image_height' => esc_attr( $full_src[2] ),
                'class'                   => esc_attr( $main_image ? 'wp-post-image' : '' ),
            ),
            $attachment_id,
            $image_size,
            $main_image
        )
    );

    return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" data-thumb-alt="' . esc_attr( $alt_text ) . '" class="woocommerce-product-gallery__image"><a href="' . esc_url( $full_src[0] ) . '" data-elementor-lightbox-slideshow="product-gallery">' . $image . '</a></div>';
}

add_filter( 'woocommerce_single_product_photoswipe_options', 'freshen_woocommerce_single_product_photoswipe_options');
function freshen_woocommerce_single_product_photoswipe_options($options){
    $options['captionEl'] = false;
    return $options;
}


add_filter( 'woosc_button_position_archive_default', 'freshen_woosc_button_position_archive_default' );
function freshen_woosc_button_position_archive_default($return) {
    return '';
}

add_filter( 'woosw_button_position_archive_default', 'freshen_woosw_button_position_archive_default' );
function freshen_woosw_button_position_archive_default($return) {
    return '';
}