<?php

// Shop Archive settings
function freshen_woo_redux_config($sections, $sidebars, $columns) {
    $attributes = array();
    if ( is_admin() ) {
        $attrs = wc_get_attribute_taxonomies();
        if ( $attrs ) {
            foreach ( $attrs as $tax ) {
                $attributes[wc_attribute_taxonomy_name( $tax->attribute_name )] = $tax->attribute_label;
            }
        }
    }
    $sections[] = array(
        'icon' => 'el el-shopping-cart',
        'title' => esc_html__('Shop Settings', 'freshen'),
        'fields' => array(
            array(
                'id' => 'products_general_total_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'enable_shop_catalog',
                'type' => 'switch',
                'title' => esc_html__('Enable Shop Catalog', 'freshen'),
                'default' => 0,
                'subtitle' => esc_html__('Enable Catalog Mode for disable Add To Cart button, Cart, Checkout', 'freshen'),
            ),
            array(
                'id' => 'products_breadcrumb_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Breadcrumbs Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'show_product_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'freshen'),
                'default' => 1
            ),
            array(
                'title' => esc_html__('Breadcrumbs Background Color', 'freshen'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'freshen').'</em>',
                'id' => 'woo_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'woo_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'freshen'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'freshen'),
            ),
        )
    );
    // Archive settings
    $elementor_options = ['' => esc_html__('Choose a Elementor Template', 'freshen')];
    if ( did_action( 'elementor/loaded' ) && is_admin() && !empty($_GET['page']) && $_GET['page'] == '_options' ) {
        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();
        
        if ( !empty( $templates ) ) {
            foreach ( $templates as $template ) {
                $elementor_options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
    }
    $sections[] = array(
        'title' => esc_html__('Product Archives', 'freshen'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'products_top_section_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Top Shop Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'shop_elementor_template',
                'type' => 'select',
                'title' => esc_html__('Top Content (Elementor Template)', 'freshen'),
                'subtitle' => esc_html__('Choose a Elementor Template to show in top.', 'freshen'),
                'options' => $elementor_options,
                'default' => '',
            ),
            array(
                'id' => 'products_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Sidebar Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'product_archive_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'freshen'),
                'default' => false
            ),
            array(
                'id' => 'product_archive_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Archive Product Layout', 'freshen'),
                'subtitle' => esc_html__('Select the layout you want to apply on your archive product page.', 'freshen'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'freshen'),
                        'alt' => esc_html__('Main Content', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left Sidebar - Main Content', 'freshen'),
                        'alt' => esc_html__('Left Sidebar - Main Content', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main Content - Right Sidebar', 'freshen'),
                        'alt' => esc_html__('Main Content - Right Sidebar', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main'
            ),
            array(
                'id' => 'product_archive_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'freshen'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'freshen'),
                'options' => $sidebars,
                'required' => array('product_archive_layout', '=', array('left-main'))
            ),
            array(
                'id' => 'product_archive_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'freshen'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'freshen'),
                'options' => $sidebars,
                'required' => array('product_archive_layout', '=', array('main-right'))
            ),
            array(
                'id' => 'product_archive_show_filter_top',
                'type' => 'switch',
                'title' => esc_html__('Show Filter Top', 'freshen'),
                'default' => 1,
                'required' => array('product_archive_layout', '=', array('main'))
            ),
            array(
                'id' => 'products_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'product_display_mode',
                'type' => 'select',
                'title' => esc_html__('Products Layout', 'freshen'),
                'subtitle' => esc_html__('Choose a default layout archive product.', 'freshen'),
                'options' => array(
                    'grid' => esc_html__('Grid', 'freshen'),
                    'list' => esc_html__('List', 'freshen'),
                ),
                'default' => 'grid'
            ),
            array(
                'id' => 'product_columns',
                'type' => 'select',
                'title' => esc_html__('Product Columns', 'freshen'),
                'options' => $columns,
                'default' => 4,
                'required' => array('product_display_mode', '=', array('grid'))
            ),
            array(
                'id' => 'product_item_style',
                'type' => 'select',
                'title' => esc_html__('Product Style', 'freshen'),
                'options' => array(
                    'v1' => esc_html__('Style 1', 'freshen'),
                    'v2' => esc_html__('Style 2', 'freshen'),
                    'v3' => esc_html__('Style 3', 'freshen'),
                    'v4' => esc_html__('Style 4', 'freshen'),
                    'v5' => esc_html__('Style 5', 'freshen'),
                    'v6' => esc_html__('Style 6', 'freshen'),
                    'v7' => esc_html__('Style 7', 'freshen'),
                    'v8' => esc_html__('Style 8', 'freshen'),
                    'v9' => esc_html__('Style 9', 'freshen'),
                ),
                'default' => 'v1',
                'required' => array('product_display_mode', '=', array('grid'))
            ),

            array(
                'id' => 'number_products_per_page',
                'type' => 'text',
                'title' => esc_html__('Number of Products Per Page', 'freshen'),
                'default' => 12,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'show_quickview',
                'type' => 'switch',
                'title' => esc_html__('Show Quick View', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'enable_swap_image',
                'type' => 'switch',
                'title' => esc_html__('Enable Swap Image', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'product_pagination',
                'type' => 'select',
                'title' => esc_html__('Pagination Type', 'freshen'),
                'options' => array(
                    'default' => esc_html__('Default', 'freshen'),
                    'loadmore' => esc_html__('Load More Button', 'freshen'),
                    'infinite' => esc_html__('Infinite Scrolling', 'freshen'),
                ),
                'default' => 'default'
            ),


        )
    );
    
    
    // Product Page
    $sections[] = array(
        'title' => esc_html__('Single Product', 'freshen'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'product_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Setting', 'freshen').'</h3>',
            ),
            array(
                'title' => esc_html__('Breadcrumbs Background Color', 'freshen'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'freshen').'</em>',
                'id' => 'woo_breadcrumb_product_single_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'woo_breadcrumb_product_single_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'freshen'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'freshen'),
            ),
            array(
                'id' => 'woo_breadcrumb_product_check_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background Checkout Header', 'freshen'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'freshen'),
            ),
            array(
                'id' => 'product_single_version',
                'type' => 'select',
                'title' => esc_html__('Product Layout', 'freshen'),
                'options' => array(
                    'v1' => esc_html__('Layout 1', 'freshen'),
                    'v2' => esc_html__('Layout 2', 'freshen'),
                    'v3' => esc_html__('Layout 3', 'freshen'),
                ),
                'default' => 'v1',
            ),
            array(
                'id' => 'product_thumbs_position',
                'type' => 'select',
                'title' => esc_html__('Thumbnails Position', 'freshen'),
                'options' => array(
                    'thumbnails-left' => esc_html__('Thumbnails Left', 'freshen'),
                    'thumbnails-right' => esc_html__('Thumbnails Right', 'freshen'),
                    'thumbnails-bottom' => esc_html__('Thumbnails Bottom', 'freshen'),
                ),
                'default' => 'thumbnails-bottom',
            ),
            array(
                'id' => 'number_product_thumbs',
                'title' => esc_html__('Number Thumbnails Per Row', 'freshen'),
                'default' => 5,
                'min' => '1',
                'step' => '1',
                'max' => '8',
                'type' => 'slider',
            ),
            array(
                'id' => 'show_product_countdown_timer',
                'type' => 'switch',
                'title' => esc_html__('Show Product CountDown Timer', 'freshen'),
                'subtitle' => esc_html__('For only product deal', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_meta',
                'type' => 'switch',
                'title' => esc_html__('Show Product Meta', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_social_share',
                'type' => 'switch',
                'title' => esc_html__('Show Social Share', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_review_tab',
                'type' => 'switch',
                'title' => esc_html__('Show Product Review Tab', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'hidden_product_additional_information_tab',
                'type' => 'switch',
                'title' => esc_html__('Hidden Product Additional Information Tab', 'freshen'),
                'default' => 1
            ),

            array(
                'id' => 'product_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'product_single_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Single Product Sidebar Layout', 'freshen'),
                'subtitle' => esc_html__('Select the layout you want to apply on your Single Product Page.', 'freshen'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Only', 'freshen'),
                        'alt' => esc_html__('Main Only', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'freshen'),
                        'alt' => esc_html__('Left - Main Sidebar', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'freshen'),
                        'alt' => esc_html__('Main - Right Sidebar', 'freshen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main'
            ),
            array(
                'id' => 'product_single_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'freshen'),
                'default' => false
            ),
            array(
                'id' => 'product_single_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Left Sidebar', 'freshen'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'freshen'),
                'options' => $sidebars
            ),
            array(
                'id' => 'product_single_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Right Sidebar', 'freshen'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'freshen'),
                'options' => $sidebars
            ),

            array(
                'id' => 'product_block_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Product Block Setting', 'freshen').'</h3>',
            ),
            array(
                'id' => 'show_product_releated',
                'type' => 'switch',
                'title' => esc_html__('Show Products Releated', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'releated_product_columns',
                'type' => 'select',
                'title' => esc_html__('Releated Products Columns', 'freshen'),
                'options' => $columns,
                'default' => 4,
                'required' => array('show_product_releated', '=', true)
            ),

            array(
                'id' => 'show_product_upsells',
                'type' => 'switch',
                'title' => esc_html__('Show Products upsells', 'freshen'),
                'default' => 1
            ),
            array(
                'id' => 'upsells_product_columns',
                'type' => 'select',
                'title' => esc_html__('Upsells Products Columns', 'freshen'),
                'options' => $columns,
                'default' => 4,
                'required' => array('show_product_upsells', '=', true)
            ),
        )
    );
    
    return $sections;
}
add_filter( 'freshen_redux_framwork_configs', 'freshen_woo_redux_config', 10, 3 );