<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Freshen_Elementor_Woo_Products_Deal2 extends Widget_Base {

	public function get_name() {
        return 'apus_element_woo_products_deal2';
    }

	public function get_title() {
        return esc_html__( 'Apus Products Deal 2', 'freshen' );
    }

    public function get_icon() {
        return 'fa fa-shopping-bag';
    }

	public function get_categories() {
        return [ 'freshen-elements' ];
    }

	protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'freshen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Widget Title', 'freshen' ),
                'type' => Controls_Manager::TEXT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'product_id', [
                'label' => esc_html__( 'Product ID', 'freshen' ),
                'type' => Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'end_date', [
                'label' => esc_html__( 'End Date', 'freshen' ),
                'type' => Controls_Manager::DATE_TIME,
                'picker_options' => [
                    'enableTime' => false
                ]
            ]
        );
        $repeater->add_control(
            'available', [
                'label' => esc_html__( 'Available', 'freshen' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 5
            ]
        );
        $repeater->add_control(
            'already_sold', [
                'label' => esc_html__( 'Already Sold', 'freshen' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 10
            ]
        );

        $this->add_control(
            'products',
            [
                'label' => esc_html__( 'Products Deal', 'freshen' ),
                'type' => Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your product tabs here', 'freshen' ),
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'freshen'),
                    'carousel' => esc_html__('Carousel', 'freshen'),
                ),
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'arrow_position',
            [
                'label' => esc_html__( 'Navigation Position', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Normal', 'freshen'),
                    'arrow-top' => esc_html__('Top', 'freshen'),
                ),
                'condition' => [
                    'layout_type' => 'carousel',
                ],
                'default' => ''
            ]
        );

        $this->add_responsive_control(
            'top',
            [
                'label' => esc_html__( 'Top', 'freshen' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => -46,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .arrow-top .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'arrow_position' => 'arrow-top',
                ],
            ]
        );

        $this->add_control(
            'product_item',
            [
                'label' => esc_html__( 'Product Item', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'inner-deal2-v1' => esc_html__('Item 1', 'freshen'),
                    'inner-deal2-v2' => esc_html__('Item 2', 'freshen'),
                ),
                'default' => 'inner-deal2-v1',
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'freshen' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 1,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'freshen' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'freshen' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'freshen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'freshen' ),
                'label_off'     => esc_html__( 'Hide', 'freshen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'freshen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'freshen' ),
                'label_off'     => esc_html__( 'Hide', 'freshen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'freshen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'freshen' ),
                'label_off'     => esc_html__( 'No', 'freshen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'freshen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'freshen' ),
                'label_off'     => esc_html__( 'No', 'freshen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'freshen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'freshen' ),
            ]
        );

        $this->end_controls_section();


        // Style
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Box Style', 'freshen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'widget_title_color',
            [
                'label' => esc_html__( 'Widget Title Color', 'freshen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Widget Title Typography', 'freshen' ),
                'name' => 'widget_title_typography',
                'selector' => '{{WRAPPER}} .widget-title',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => esc_html__( 'Border', 'freshen' ),
                'selector' => '{{WRAPPER}} .product-block',
            ]
        );

        $this->add_control(
            'box_hover_border_color',
            [
                'label' => esc_html__( 'Border Hover Color', 'freshen' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-block:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__( 'Box Shadow Hover', 'freshen' ),
                'selector' => '{{WRAPPER}} .product-block:hover',
            ]
        );

        $this->end_controls_section();

        
        $this->start_controls_section(
            'section_product_style',
            [
                'label' => esc_html__( 'Product Style', 'freshen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        if ( $products ) {
        ?>
            <div class="woocommerce widget widget-products-deal <?php echo esc_attr($el_class); ?>">
                <?php if ( !empty($title) ): ?>
                    <h3 class="widget-title">
                        <?php echo esc_attr( $title ); ?>
                    </h3>
                <?php endif; ?>
                <div class="widget-content <?php echo esc_attr($layout_type); ?>">
                    <?php if ( $layout_type == 'carousel' ) { ?>

                        <?php
                        $show_nav = isset($show_nav) ? $show_nav : false;
                        $show_pagination = isset($show_pagination) ? $show_pagination : false;

                        $rows = isset($rows) ? $rows : 1;
                        $columns = !empty($columns) ? $columns : 3;
                        $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 3;
                        $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 2;

                        $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : $columns;
                        $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $slides_to_scroll;
                        $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : 1;

                        $infinite_loop = isset($infinite_loop) ? $infinite_loop : false;
                        $autoplay = isset($autoplay) ? $autoplay : false;
                        ?>
                        <div class="slick-carousel products <?php echo trim($arrow_position); ?>"
                            data-items="<?php echo esc_attr($columns); ?>"
                            data-smallmedium="<?php echo esc_attr( $columns_tablet ); ?>"
                            data-extrasmall="<?php echo esc_attr($columns_mobile); ?>"

                            data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                            data-slidestoscroll_smallmedium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                            data-slidestoscroll_extrasmall="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

                            data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>" data-rows="<?php echo esc_attr( $rows ); ?>">

                            <?php
                            foreach ($products as $data) {
                                if ( !empty($data['product_id']) ) {
                                    $post_object = get_post( $data['product_id'] );
                                    if ( $post_object ) {
                                        setup_postdata( $GLOBALS['post'] =& $post_object );
                                        global $product;
                                        if ( !empty($product) ) {
                                        ?>
                                            <div class="products-grid product">
                                                <?php wc_get_template( 'item-product/'.$product_item.'.php', array(
                                                    'end_date' => !empty($data['end_date']) ? $data['end_date'] : '',
                                                    'available' => !empty($data['available']) ? $data['available'] : '',
                                                    'already_sold' => !empty($data['already_sold']) ? $data['already_sold'] : '',
                                                ) ); ?>
                                            </div>
                                        <?php
                                        }
                                    }
                                }
                            }
                            wp_reset_postdata();
                            ?>
                        </div>
                    <?php } else { ?>
                        <div class="row">
                            <?php
                            $columns = !empty($columns) ? $columns : 3;
                            if($columns > 1){
                                $columns_tablet = 3;
                                $columns_mobile = 2;
                            }else{
                                $columns_tablet = 1;
                                $columns_mobile = 1;
                            }

                            $mdcol = 12/$columns;
                            $smcol = 12/$columns_tablet;
                            $xscol = 12/$columns_mobile;

                            if( $columns == 5 ){
                                $mdcol = '5c';
                            }

                            if( $columns_tablet == 5 ){
                                $smcol = '5c';
                            }

                            if( $columns_mobile == 5 ){
                                $xscol = '5c';
                            }

                            $classes = array();

                            $classes[] = 'col-md-'.$mdcol.' col-sm-'.$smcol.' col-xs-'.$xscol;

                            $count = 0;
                            foreach ($products as $data) {
                                
                                if ( !empty($data['product_id']) ) {
                                    $post_object = get_post( $data['product_id'] );
                                    if ( $post_object ) {
                                        setup_postdata( $GLOBALS['post'] =& $post_object );
                                        global $product;
                                        if ( !empty($product) ) {
                                            $pclasses = $classes;
                                            if ( $count%$columns == 0 ) {
                                                $pclasses[] = 'md-clearfix lg-clearfix ';
                                            }
                                            ?>
                                                <div <?php wc_product_class( $pclasses, $post_object ); ?>>
                                                    <?php wc_get_template( 'item-product/'.$product_item.'.php', array(
                                                        'end_date' => !empty($data['end_date']) ? $data['end_date'] : '',
                                                        'available' => !empty($data['available']) ? $data['available'] : '',
                                                        'already_sold' => !empty($data['already_sold']) ? $data['already_sold'] : '',
                                                    ) ); ?>
                                                </div>
                                            <?php
                                            $count++;
                                        }
                                    }
                                }
                            }
                            wp_reset_postdata();
                            ?>
                        </div>
                    <?php } ?>

                </div>
            </div>
            <?php
        }
    }

}

if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Freshen_Elementor_Woo_Products_Deal2 );
} else {
    Plugin::instance()->widgets_manager->register( new Freshen_Elementor_Woo_Products_Deal2 );
}