<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Freshen_Elementor_Woo_Category_Banner extends Widget_Base {

	public function get_name() {
        return 'apus_element_woo_category_banner';
    }

	public function get_title() {
        return esc_html__( 'Apus Product Category Banner', 'freshen' );
    }

    public function get_icon() {
        return 'fa fa-shopping-bag';
    }

	public function get_categories() {
        return [ 'freshen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'freshen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Height', 'freshen' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget-category-banner' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'freshen' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'This is the heading', 'freshen' ),
                'placeholder' => esc_html__( 'Enter your title', 'freshen' ),
            ]
        );

        $this->add_control(
            'slug', [
                'label' => esc_html__( 'Category Slug', 'freshen' ),
                'type' => Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'link_url',
            [
                'label' => esc_html__( 'Link', 'freshen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'https://your-link.com', 'freshen' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_subcategories',
            [
                'label' => esc_html__( 'Show SubCategories', 'freshen' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'freshen' ),
                'label_off' => esc_html__( 'Show', 'freshen' ),
            ]
        );

        $this->add_control(
            'number_subcategories',
            [
                'label' => esc_html__( 'Number SubCategories', 'freshen' ),
                'type' => Controls_Manager::NUMBER,
                'placeholder' => esc_html__( 'Enter number subcategories', 'freshen' ),
                'default' => 5,
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'freshen'),
                ),
                'default' => 'style1'
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'freshen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'freshen' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Style', 'freshen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'freshen' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .widget-category-banner',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'freshen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__( 'Title Hover Color', 'freshen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .item-inner-categories:hover .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'freshen' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'freshen' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .widget-category-banner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        ?>

        <div class="widget-category-banner <?php echo esc_attr($style.' '.$el_class); ?>">
                <?php
                $html = $link = '';
                $title_html = $title;
                $term = get_term_by('slug', $slug, 'product_cat');
                
                if ( ! empty( $link_url ) ) {
                    $link = $link_url;
                }
                if ( $term ) {
                    $link = get_term_link($term);
                    if ( empty($title_html) ) {
                        $title_html = $term->name;
                    }
                }

                $html .= '<div class="category-box-content">';

                if ( ! empty( $link ) ) {
                    $html .= '<a href="'.esc_url($link).'"><h3 class="title">'.$title_html.'</h3></a>';
                } else {
                    $html .= sprintf( '<h3 class="title">%1$s</h3>', $title_html );
                }

                if ( $term ) {
                    if ( $show_subcategories ) {
                        $terms_children = get_terms( 'product_cat',
                            array(
                                'parent'        => $term->term_id,
                                'hierarchical'  => true,
                                'hide_empty'    => false,
                                'number'    => $number_subcategories,
                            )
                        );
                        if ( ! empty( $terms_children ) && ! is_wp_error( $terms_children ) ) {
                            $html .= '<ul class="subcategories">';
                                foreach ($terms_children as $term_children) {
                                    $html .= '<li><a href="'.get_term_link($term_children).'">'.$term_children->name.'</a></li>';
                                }
                            $html .= '</ul>';
                        }
                    }
                }

                $html .= '</div>';

                echo trim($html);

                if ( ! empty( $link ) ) {
                ?>
                    <div class="more-categories">
                        <a href="<?php echo esc_url($link); ?>" class="btn-banner st-theme"><?php echo esc_html__('VIEW ALL','freshen'); ?></a>
                    </div>
                <?php } ?>
        </div>

        <?php
    }
}

if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Freshen_Elementor_Woo_Category_Banner );
} else {
    Plugin::instance()->widgets_manager->register( new Freshen_Elementor_Woo_Category_Banner );
}