<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Freshen_Elementor_Woo_Lookbook extends Widget_Base {

	public function get_name() {
        return 'apus_element_woo_lookbook';
    }

	public function get_title() {
        return esc_html__( 'Apus Lookbook', 'freshen' );
    }

    public function get_icon() {
        return 'fa fa-shopping-bag';
    }

	public function get_categories() {
        return [ 'freshen-elements' ];
    }

	protected function register_controls() {
        $posts = get_posts(
            array(
                'post_type' => 'lookbook',
                'number' => -1,
            )
        );
        $pposts = [ '' => esc_html__('Choose a lookbook', 'freshen') ];
        if ( !empty($posts) ) {
            foreach ($posts as $post) {
                $pposts[$post->post_name] = $post->post_title;
            }
        }
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'freshen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title', [
                'label' => esc_html__( 'Widget Title', 'freshen' ),
                'type' => Controls_Manager::TEXT
            ]
        );
        
        $this->add_control(
            'lookbook',
            [
                'label' => esc_html__( 'Lookbook', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => $pposts,
            ]
        );

        $this->add_control(
            'product_item',
            [
                'label' => esc_html__( 'Product Item', 'freshen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'inner' => esc_html__('Item 1', 'freshen'),
                    'inner-v2' => esc_html__('Item 2', 'freshen'),
                    'inner-v3' => esc_html__('Item 3', 'freshen'),
                    'inner-v4' => esc_html__('Item 4', 'freshen'),
                    'inner-v5' => esc_html__('Item 5', 'freshen'),
                    'inner-v6' => esc_html__('Item 6', 'freshen'),
                    'inner-v7' => esc_html__('Item 7', 'freshen'),
                    'inner-v8' => esc_html__('Item 8', 'freshen'),
                    'inner-v9' => esc_html__('Item 9', 'freshen'),
                ),
                'default' => 'inner',
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'freshen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'freshen' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Box Style', 'freshen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'widget_title_color',
            [
                'label' => esc_html__( 'Widget Title Color', 'freshen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Widget Title Typography', 'freshen' ),
                'name' => 'widget_title_typography',
                'selector' => '{{WRAPPER}} .widget-title',
            ]
        );

        $this->add_responsive_control(
            'title_align',
            [
                'label' => esc_html__( 'Alignment', 'freshen' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'freshen' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'freshen' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'freshen' ),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'freshen' ),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .widget-title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_product_style',
            [
                'label' => esc_html__( 'Product Style', 'freshen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius Button', 'freshen' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .product-block.grid .button,
                    {{WRAPPER}} .product-block.grid .button.loading:before,
                     {{WRAPPER}} .product-block.grid .added_to_cart' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($lookbook) ) {
            ?>
            <div class="widget widget-lookbook <?php echo esc_attr($el_class); ?>">
               <?php echo do_shortcode('[lookbook slug="'.$lookbook.'" product_item="'.$product_item.'" title="'.$title.'" ]'); ?>
            </div>
            <?php
        }
    }
}

if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Freshen_Elementor_Woo_Lookbook );
} else {
    Plugin::instance()->widgets_manager->register( new Freshen_Elementor_Woo_Lookbook );
}