<?php

if ( !function_exists( 'freshen_product_metaboxes' ) ) {
	function freshen_product_metaboxes(array $metaboxes) {
		$prefix = 'apus_product_';
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'freshen' )), freshen_get_header_layouts() );
	    $fields = array(
	    	array(
                'id' => $prefix.'layout_type',
                'type' => 'select',
                'name' => esc_html__('Layout Type', 'freshen'),
                'options' => array(
                    '' => esc_html__('Global Settings', 'freshen'),
                    'v1' => esc_html__('Layout 1', 'freshen'),
                    'v2' => esc_html__('Layout 2', 'freshen'),
                    'v3' => esc_html__('Layout 3', 'freshen'),
                )
            ),
	    	array(
				'name' => esc_html__( 'Review Video', 'freshen' ),
				'id'   => $prefix.'review_video',
				'type' => 'text',
				'description' => esc_html__( 'You can enter a video youtube or vimeo', 'freshen' ),
			),
    	);

	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'More Information', 'freshen' ),
			'object_types'              => array( 'product' ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'freshen_product_metaboxes' );
