<?php
if ( !function_exists ('freshen_custom_styles') ) {
	function freshen_custom_styles() {
		global $post;	
		
		ob_start();	
		?>
		
			<?php if ( freshen_get_config('main_color') != "" ) {
				$main_color = freshen_get_config('main_color');
			} else {
				$main_color = '#86BC42';
			}


			if ( freshen_get_config('main_hover_color') != "" ) {
				$main_hover_color = freshen_get_config('main_hover_color');
			} else {
				$main_hover_color = '#6b9635';
			}

			if ( freshen_get_config('text_color') != "" ) {
				$text_color = freshen_get_config('text_color');
			} else {
				$text_color = '#4F4F4F';
			}

			if ( freshen_get_config('link_color') != "" ) {
				$link_color = freshen_get_config('link_color');
			} else {
				$link_color = '#121212';
			}

			if ( freshen_get_config('heading_color') != "" ) {
				$heading_color = freshen_get_config('heading_color');
			} else {
				$heading_color = '#121212';
			}
			

			$main_color_rgb = freshen_hex2rgb($main_color);

			// font
			$main_font = freshen_get_config('main_font');
			$main_font_family = !empty($main_font['font-family']) ? $main_font['font-family'] : 'Lato';
			$main_font_weight = !empty($main_font['font-weight']) ? $main_font['font-weight'] : 400;

			$main_font_arr = explode(',', $main_font_family);
			if ( count($main_font_arr) == 1 ) {
				$main_font_family = "'".$main_font_family."'";
			}

			$heading_font = freshen_get_config('heading_font');
			$heading_font_family = !empty($heading_font['font-family']) ? $heading_font['font-family'] : 'Signika';
			$heading_font_weight = !empty($heading_font['font-weight']) ? $heading_font['font-weight'] : 700;

			$heading_font_arr = explode(',', $heading_font_family);
			if ( count($heading_font_arr) == 1 ) {
				$heading_font_family = "'".$heading_font_family."'";
			}
			?>
			:root {
			  --freshen-theme-color: <?php echo trim($main_color); ?>;
			  --freshen-text-color: <?php echo trim($text_color); ?>;
			  --freshen-link-color: <?php echo trim($link_color); ?>;
			  --freshen-heading-color: <?php echo trim($heading_color); ?>;
			  --freshen-theme-hover-color: <?php echo trim($main_hover_color); ?>;
			  --freshen-theme-color-001: <?php echo freshen_generate_rgba($main_color_rgb, 0.01); ?>
			  --freshen-theme-color-01: <?php echo freshen_generate_rgba($main_color_rgb, 0.1); ?>

			  --freshen-main-font: <?php echo trim($main_font_family); ?>;
			  --freshen-main-font-weight: <?php echo trim($main_font_weight); ?>;
			  --freshen-heading-font: <?php echo trim($heading_font_family); ?>;
			  --freshen-heading-font-weight: <?php echo trim($heading_font_weight); ?>;
			}
			
			<?php if (  freshen_get_config('header_mobile_color') != "" ) : ?>
				#apus-header-mobile {
					background-color: <?php echo esc_html( freshen_get_config('header_mobile_color') ); ?>;
				}
			<?php endif; ?>

	<?php
		$content = ob_get_clean();
		$content = str_replace(array("\r\n", "\r"), "\n", $content);
		$lines = explode("\n", $content);
		$new_lines = array();
		foreach ($lines as $i => $line) {
			if (!empty($line)) {
				$new_lines[] = trim($line);
			}
		}
		
		return implode($new_lines);
	}
}