<?php
/**
 * Custom Header functionality for Freshen
 *
 * @package WordPress
 * @subpackage Freshen
 * @since Freshen 1.0
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses freshen_header_style()
 */
function freshen_custom_header_setup() {
	$color_scheme        = freshen_get_color_scheme();
	$default_text_color  = trim( $color_scheme[4], '#' );

	/**
	 * Filter Freshen custom-header support arguments.
	 *
	 * @since Freshen 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type string $default_text_color     Default color of the header text.
	 *     @type int    $width                  Width in pixels of the custom header image. Default 954.
	 *     @type int    $height                 Height in pixels of the custom header image. Default 1300.
	 *     @type string $wp-head-callback       Callback function used to styles the header image and text
	 *                                          displayed on the blog.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'freshen_custom_header_args', array(
		'default-text-color'     => $default_text_color,
		'width'                  => 954,
		'height'                 => 1300,
		'wp-head-callback'       => 'freshen_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'freshen_custom_header_setup' );

/**
 * Convert HEX to RGB.
 *
 * @since Freshen 1.0
 *
 * @param string $color The original color, in 3- or 6-digit hexadecimal form.
 * @return array Array containing RGB (red, green, and blue) values for the given
 *               HEX code, empty array otherwise.
 */

if ( ! function_exists( 'freshen_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 *
 * @since Freshen 1.0
 *
 * @see freshen_custom_header_setup()
 */
function freshen_header_style() {
	return '';
}
endif; // freshen_header_style

