<?php
/**
 * The template part for displaying results in search pages
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage Freshen
 * @since Freshen 1.0
 */
?>
<article <?php post_class('post post-layout post-list'); ?>>
    <div class="inner-right">
        <?php freshen_post_first_categories($post); ?>
        <?php if (get_the_title()) { ?>
            <h4 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
        <?php } ?>
        <div class="post-layout-info hidden-xs">
            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="flaticon-user"></i><?php echo esc_html__('By','freshen') ?> <?php echo get_the_author(); ?></a>
            <span class="comments"><i class="flaticon-chat"></i><?php comments_number( esc_html__('0 Comments', 'freshen'), esc_html__('1 Comment', 'freshen'), esc_html__('% Comments', 'freshen') ); ?></span>
        </div>
        <?php if( !empty( get_the_excerpt() ) ){?>
            <div class="description hidden-xs"><?php echo freshen_substring( get_the_excerpt(), 28, '...' ); ?></div>
        <?php } ?>
        <div class="readmore hidden-xs hidden-sm">
            <a class="btn-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Continue Reading', 'freshen'); ?></a>
        </div>
    </div>
</article>