<?php

if (!isset($slug) || !$slug)
	return;

$args = array(
  'name'        => $slug,
  'post_type'   => 'lookbook',
  'post_status' => 'publish',
  'numberposts' => 1
);
$posts = get_posts($args);
if( $posts ) {
  $post = $posts[0];
} else {
	return;
}
$zones = get_post_meta($post->ID, 'apus_lookbook_zones', true);
$image = get_post_meta($post->ID, 'apus_lookbook_image', true);

if (empty($image)) {
	return;
}
$product_item = !empty($product_item) ? $product_item : 'inner';
?>
<div class="apus-lookbook-wrapper woocommerce">
	<?php if ( !empty($title) && empty($zones) ): ?>
        <h3 class="widget-title">
            <?php echo esc_attr( $title ); ?>
        </h3>
    <?php endif; ?>
	<div class="row flex-middle-sm">
		<?php
		$col_class = $col_class_sm = 12;
		if ( !empty($zones) ) {
			$col_class = 9;
			$col_class_sm = 8;
			?>
			<div class="col-md-3 col-sm-4">

				<?php if ( !empty($title) ): ?>
	                <h3 class="widget-title">
	                    <?php echo esc_attr( $title ); ?>
	                </h3>
	            <?php endif; ?>

				<div class="slick-carousel products arrow-small" data-items="1" data-smallmedium="1" data-extrasmall="1" data-slidestoscroll="1" data-slidestoscroll_smallmedium="1" data-slidestoscroll_extrasmall="1" data-pagination="false" data-nav="true">

					<?php foreach ($zones as $zone):
						$post_object = ApusLookbook_Helper::getPost($zone);
						if ($post_object):
							setup_postdata( $GLOBALS['post'] =& $post_object );
					?>	
						<div class="product clearfix">
							<?php wc_get_template_part( 'item-product/'.$product_item ); ?>
						</div>
						<?php endif; ?>
					<?php endforeach; ?>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
		<?php } ?>
	
		<div class="col-md-<?php echo esc_attr($col_class); ?> col-sm-<?php echo esc_attr($col_class_sm); ?>">
			<div class="apus-lookbook" style="position: relative">
				<img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($post->post_title); ?>">
				<?php foreach ($zones as $zone):
					$post = ApusLookbook_Helper::getPost($zone);
					if ($post):
				?>
						<div data-href="<?php echo esc_url(get_permalink($post->ID)); ?>" class="mapper-pin"
							style="width:<?php echo esc_attr($zone['width']); ?>px;height:<?php echo esc_attr($zone['height']); ?>px;left:<?php echo esc_attr($zone['x1']); ?>% ;top:<?php echo esc_attr($zone['y1']); ?>%; position: absolute;">
							<div class="mapper-pin-wrapper">
								<a href="<?php echo get_permalink( $post->ID ); ?>"></a>
							</div>
						</div>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>