<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Freshen
 * @since Freshen 1.0
 */
/*
*Template Name: 404 Page
*/
get_header();
//freshen_render_breadcrumbs();
$bgimg = freshen_get_config('bg-img');
$top_img = freshen_get_config('top-img');
$style = '';
if ( !empty($bgimg['id']) ) {
	$img = wp_get_attachment_image_src($bgimg['id'], 'full');
	if ( !empty($img[0]) ) {
		$style = 'style="background-image: url('.$img[0].');"';
	}
}
?>
<section class="page-404" <?php echo trim($style); ?>>
	<div id="main-container" class="inner">
		<div id="main-content" class="main-page">
			<section class="error-404 not-found clearfix">
				<div class="container">
					<div class="row">

						<div class="col-sm-12 text-center">
							<div class="slogan">
								<div class="top-image">
									<?php if( !empty($top_img) && !empty($top_img['url'])) { ?>
										<img src="<?php echo esc_url( $top_img['url']); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php }else{ ?>
										<img class="w-610" src="<?php echo esc_url( get_template_directory_uri().'/images/error-top.png'); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php } ?>
								</div>
								<h1 class="greeting_title">
									<?php
									$title = freshen_get_config('greeting_title');
									if ( !empty($title) ) {
										echo esc_html($title);
									} else {
										esc_html_e('OOPS!', 'freshen');
									}
									?>
								</h1>
							</div>
							<div class="page-content">
								<div class="description">
									<?php
									$desc = freshen_get_config('404_description');
									if ( !empty($desc) ) {
										echo trim($desc);
									} else {
										esc_html_e('Sorry bit the page you are looking for does not exist, have been removed or name changed', 'freshen');
									}
									?>
								</div>
								<div class="return">
									<a class="btn btn-theme" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html__('BACK HOMEPAGE','freshen') ?></a>
								</div>
							</div><!-- .page-content -->
						</div>
					</div>
				</div>
			</section><!-- .error-404 -->
		</div><!-- .content-area -->
	</div>
</section>
<?php get_footer(); ?>